//=============================================================================
// TeamGamePlus.
//=============================================================================
class InstantAction extends TeamGamePlus config(IAConfig);

var()		 bool   bSpawnInTeamArea;
var()		 bool	bScoreTeamKills;
var() config bool	bNoTeamChanges;
var			 int	NumSupportingPlayer; 
var globalconfig	 bool	bBalanceTeams;	// bots balance teams
var globalconfig	 bool	bPlayersBalanceTeams;	// players balance teams
var			 bool	bBalancing;
var() config float  FriendlyFireScale; //scale friendly fire damage by this value
var() config int	MaxTeams; //Maximum number of teams allowed in (up to MaxAllowedTeams)
var			 int	MaxAllowedTeams;
var	TeamInfo Teams[4]; // Red, Blue, Green, Gold
var() config float  GoalTeamScore; //like fraglimit
var() config int	MaxTeamSize;
var  localized string StartUpTeamMessage, TeamChangeMessage,TeamPrefix;
var localized string TeamColor[4];

var		int			NextBotTeam;
var byte TEAM_Red, TEAM_Blue, TEAM_Green, TEAM_Gold;
var name CurrentOrders[4];
var int PlayerTeamNum;
var localized string StartupTeamTralier;

//custom vars:
var int NumStartingPoints; // holds how many PlayerStarts there is available in the map
var bool bDBupdated;
//database vars:
var config string 	Players[10000];
var config int 		Scores[10000];
//Temp game vars:
var string 	TempPlayers[128];
var int 	TempScores[128];
var int 	Level[128];
var int		AddToDamage[128];
var int		HealthRegain[128];
var int		AmmoRegain[128];
var int		ReducedDamage[128];
var int		HealthStolen[128];
var int		MaxHealth[128];	
var int		AmmoStolen[128];
var int		ArmorStolen[128];

function CalculateLevel()
{
local float XL,YL;
local int Lev,i,ii,a;
local int l;

	for (l=0;l<128;l++)
		{
		if (TempScores[l] != 0 )
			{
			//Calculate Level
			a=200;
			ii = TempScores[l];
			for (i=0;i<9999;i++)
				{
				Lev++;
				a *= 1.5;
				if (a > ii)
					{
					i = 10000;
					}
				}
			Level[l] = Lev;
			AssignStats(l,Lev);
			}
		else
			{
			l = 256;
			}
		}
}

//l = TempPlayer number, Lev = current Level
function AssignStats(int l, int Lev)
{
	if (Lev == 2)
		{
		// set something
		}		
}

function UpdateDB()
{
local int i,ii;

	if (bDBupdated)
		return;

	for (i=0;i<128;i++)
		{
		if ( TempPlayers[i] != "" )
			{
			for (ii=0;ii<10000;ii++)
				{
				if ( TempPlayers[i] == Players[ii] || Players[ii] == "" )
					{
					Players[ii] = TempPlayers[i];
					Scores[ii] = TempScores[i];
					ii = 20000;
					}
				}
			}
		bDBupdated = True;
		}
	SaveConfig();
}

function HandleTemp()
{
local int i;
local Pawn P;

	for (P = Level.PawnList; P != None; P = P.NextPawn)
		{
		if ( P.IsA('PlayerPawn'))
			{
			for (i=0;i<128;i++)
				{
				if (TempPlayers[i] == P.PlayerReplicationInfo.PlayerName || TempPlayers[i] == "")
					{
					TempPlayers[i] = P.PlayerReplicationInfo.PlayerName;
					TempScores[i] = P.PlayerReplicationInfo.Score;
					i=256;
					}
				}
			}
		}
}

event playerpawn Login(string Portal,string Options,out string Error,class<playerpawn> SpawnClass)
{
local playerpawn NewPlayer;
local int i,ii;

	if ( (Level.NetMode != NM_Standalone) && (NumCommanders >= MaxCommanders) && ClassIsChildOf(SpawnClass, class'Commander') )
	{
		Error="Max commanders "$MaxCommanders$" exceeded";
		return None;
	}

	NewPlayer = Super.Login(Portal, Options, Error, SpawnClass);

	if ( NewPlayer != None )
		{
		if ( bRatedGame )
			NewPlayer.AirControl = 0.35;
		else
			NewPlayer.AirControl = AirControl;
		if ( Left(NewPlayer.PlayerReplicationInfo.PlayerName, 6) == DefaultPlayerName )
			{
			if (Level.Game.WorldLog != None)
				Level.Game.WorldLog.LogSpecialEvent("forced_name_change", NewPlayer.PlayerReplicationInfo.PlayerName, NewPlayer.PlayerReplicationInfo.PlayerID, DefaultPlayerName$NumPlayers);
			ChangeName( NewPlayer, (DefaultPlayerName$NumPlayers), false );
			}
		NewPlayer.bAutoActivate = true;
		if ( (bGameEnded || (bRequireReady && (CountDown > 0))) && !NewPlayer.IsA('Spectator') )
			NewPlayer.PlayerRestartState = 'PlayerWaiting';
		else
			NewPlayer.PlayerRestartState = NewPlayer.Default.PlayerRestartState;

		if ( NewPlayer.IsA('TournamentPlayer') )
			{
			TournamentPlayer(NewPlayer).StartSpot = LastStartSpot;
			if ( NewPlayer.IsA('Commander') )
				NumCommanders++;
			}
		for (i=0;i<10000;i++)
			{
			if (Players[i] == NewPlayer.PlayerReplicationInfo.PlayerName || Players[i] == "")
				{
				Players[i] = NewPlayer.PlayerReplicationInfo.PlayerName;
				NewPlayer.PlayerReplicationInfo.Score = Scores[i];
				i = 20000;
				}
			}
		}
	return NewPlayer;
}

function PlayTeleportEffect( actor Incoming, bool bOut, bool bSound)
{
 	local UTTeleportEffect PTE;

	if ( Incoming.IsA('Bot'))
		{
		if (Bot(Incoming).PlayerReplicationInfo.Deaths > 0 )
			{
			return;
			}
		}

	if ( bRequireReady && (Countdown > 0) )
		return;

	if ( Incoming.bIsPawn && (Incoming.Mesh != None) )
	{
		if ( bSound )
		{
 			PTE = Spawn(class'UTTeleportEffect',Incoming,, Incoming.Location, Incoming.Rotation);
 			PTE.Initialize(Pawn(Incoming), bOut);
			PTE.PlaySound(sound'Resp2A',, 10.0);
		}
	}
}

function PostBeginPlay() 
{
local PlayerStart PS;
local NavigationPoint NP;

	NumStartingPoints = 0;
	for (NP = Level.NavigationPointList; NP != None; NP = NP.NextNavigationPoint)
		if (NP.IsA('PlayerStart'))
			NumStartingPoints++;

	Super(TeamGamePlus).PostBeginPlay();

}

//funtion rewritten to spawn players at team 0 (Red) and bots to team 1 (Blue)
function AddToTeam( int num, Pawn Other )
{
	local teaminfo aTeam;
	local Pawn P;
	local bool bSuccess;
	local string SkinName, FaceName;

	if ( Other == None )
		{
		log("Added none to team!!!");
		return;
		}
	if ( Other.IsA('PlayerPawn') )
		{
		Other.PlayerReplicationInfo.Team = 0;
		Other.static.GetMultiSkin(Other, SkinName, FaceName);
		Other.static.SetMultiSkin(Other, SkinName, FaceName, 0);
		GiveWeapon(Other,"BotPack.enforcer");
		}
	else
		{
		Other.PlayerReplicationInfo.Team = 1;
		Other.static.GetMultiSkin(Other, SkinName, FaceName);
		Other.static.SetMultiSkin(Other, SkinName, FaceName, 1);
		}
	ReBalance();
}

function AddNewEnemy()
{
local NavigationPoint NP;
local int Number, Counter, Enemy;

	Number = Rand(NumStartingPoints);
	Counter = 0;

	for (NP = Level.NavigationPointList; NP != None; NP = NP.NextNavigationPoint)
		{
		if (NP.IsA('PlayerStart'))
			{
			If ( Number == Counter)
				{
				Enemy = Rand(18);
				if (Enemy < 1)
					{
					SpawnMaleAssassin(NP);
					}
				else if (Enemy < 4)
					{
					SpawnMaleKnight(NP);
					}
				else if (Enemy < 5)
					{
					SpawnDarkAngel(NP);
					}
				else if (Enemy < 6)
					{
					SpawnFemaleWarMachine(NP);
					}
				else if (Enemy < 7)
					{
					SpawnFemaleMarine(NP);
					}
				else if (Enemy < 8)
					{
					SpawnDarkXan(NP);
					}
				else if (Enemy < 11)
					{
					SpawnCamoXan(NP);
					}
				else if (Enemy < 12)
					{
					SpawnBossXian(NP);
					}
				else if (Enemy < 15)
					{
					SpawnBossStorm(NP);
					}
				else 
					{
					SpawnFemaleKnight(NP);
					}
				}
			Counter++;
			}
		}

}

function SpawnBossStorm(NavigationPoint NP)
{
local Bot B;
local int Knight;

	Knight = Rand(5);

	if (Knight == 1)
		{
		B = spawn(class'Enemy_BossSilverStorm',,,NP.Location);
		}
	else if (Knight == 2)
		{
		B = spawn(class'Enemy_BossRedStorm',,,NP.Location);
		}
	else if (Knight == 3)
		{
		B = spawn(class'Enemy_BossBlueStorm',,,NP.Location);
		}
	else if (Knight == 4)
		{
		B = spawn(class'Enemy_BossGreenStorm',,,NP.Location);
		}
	else
		{
		B = spawn(class'Enemy_BossGoldStorm',,,NP.Location);
		}
	B.PlayerReplicationInfo.PlayerName = "StormLord";
	B.PlayerReplicationInfo.Team = 1;
	GiveWeapon(B,"BotPack.enforcer");
	B.GotoState('Attacking');
}

function SpawnBossXian(NavigationPoint NP)
{
local Bot B;
	
	B = spawn(class'Enemy_BossXian',,,NP.Location);
	B.PlayerReplicationInfo.PlayerName = "Xian";
	B.PlayerReplicationInfo.Team = 1;
	GiveWeapon(B,"BotPack.enforcer");
	B.GotoState('Attacking');
}

function SpawnCamoXan(NavigationPoint NP)
{
local Bot B;
local int Knight;

	Knight = Rand(5);

	if (Knight == 1)
		{
		B = spawn(class'Enemy_BossSilverCamo',,,NP.Location);
		}
	else if (Knight == 2)
		{
		B = spawn(class'Enemy_BossRedCamo',,,NP.Location);
		}
	else if (Knight == 3)
		{
		B = spawn(class'Enemy_BossBlueCamo',,,NP.Location);
		}
	else if (Knight == 4)
		{
		B = spawn(class'Enemy_BossGreenCamo',,,NP.Location);
		}
	else
		{
		B = spawn(class'Enemy_BossGoldCamo',,,NP.Location);
		}
	B.PlayerReplicationInfo.PlayerName = "CamoXan";
	B.PlayerReplicationInfo.Team = 1;
	GiveWeapon(B,"BotPack.enforcer");
	B.GotoState('Attacking');
}

function SpawnDarkXan(NavigationPoint NP)
{
local Bot B;
	
	B = spawn(class'Enemy_DarkXan',,,NP.Location);
	B.PlayerReplicationInfo.PlayerName = "DarkXan";
	B.PlayerReplicationInfo.Team = 1;
	GiveWeapon(B,"BotPack.enforcer");
	B.GotoState('Attacking');
}

function SpawnFemaleMarine(NavigationPoint NP)
{
local Bot B;
	
	B = spawn(class'Enemy_FemaleMarine',,,NP.Location);
	B.PlayerReplicationInfo.PlayerName = "Marine";
	B.PlayerReplicationInfo.Team = 1;
	GiveWeapon(B,"BotPack.enforcer");
	B.GotoState('Attacking');
}

function SpawnFemaleWarMachine(NavigationPoint NP)
{
local Bot B;
	
	B = spawn(class'Enemy_FemaleWarMachine',,,NP.Location);
	B.PlayerReplicationInfo.PlayerName = "WarMachine";
	B.PlayerReplicationInfo.Team = 1;
	GiveWeapon(B,"BotPack.enforcer");
	B.GotoState('Attacking');
}

function SpawnDarkAngel(NavigationPoint NP)
{
local Bot B;
	
	B = spawn(class'Enemy_FemaleDarkAngel',,,NP.Location);
	B.PlayerReplicationInfo.PlayerName = "DarkAngel";
	B.PlayerReplicationInfo.Team = 1;
	GiveWeapon(B,"BotPack.enforcer");
	B.GotoState('Attacking');
}

function SpawnFemaleKnight(NavigationPoint NP)
{
local Bot B;
local int Knight;

	Knight = Rand(5);

	if (Knight == 1)
		{
		B = spawn(class'Enemy_FemaleSilverKnight',,,NP.Location);
		}
	else if (Knight == 2)
		{
		B = spawn(class'Enemy_FemaleRedKnight',,,NP.Location);
		}
	else if (Knight == 3)
		{
		B = spawn(class'Enemy_FemaleBlueKnight',,,NP.Location);
		}
	else if (Knight == 4)
		{
		B = spawn(class'Enemy_FemaleGreenKnight',,,NP.Location);
		}
	else
		{
		B = spawn(class'Enemy_FemaleGoldKnight',,,NP.Location);
		}
	B.PlayerReplicationInfo.PlayerName = "JoanOfArc";
	B.PlayerReplicationInfo.Team = 1;
	GiveWeapon(B,"BotPack.enforcer");
	B.GotoState('Attacking');
}

function SpawnMaleKnight(NavigationPoint NP)
{
local Bot B;
local int Knight;

	Knight = Rand(5);

	if (Knight == 1)
		{
		B = spawn(class'Enemy_MaleSilverKnight',,,NP.Location);
		}
	else if (Knight == 2)
		{
		B = spawn(class'Enemy_MaleRedKnight',,,NP.Location);
		}
	else if (Knight == 3)
		{
		B = spawn(class'Enemy_MaleBlueKnight',,,NP.Location);
		}
	else if (Knight == 4)
		{
		B = spawn(class'Enemy_MaleGreenKnight',,,NP.Location);
		}
	else
		{
		B = spawn(class'Enemy_MaleGoldKnight',,,NP.Location);
		}
	B.PlayerReplicationInfo.PlayerName = "Knight";
	B.PlayerReplicationInfo.Team = 1;
	GiveWeapon(B,"BotPack.enforcer");
	B.GotoState('Attacking');
}

function SpawnMaleAssassin(NavigationPoint NP)
{
local Bot B;

	B = spawn(class'Enemy_MaleAssassin',,,NP.Location);
	B.PlayerReplicationInfo.PlayerName = "Assassin";
	B.PlayerReplicationInfo.Team = 1;
	GiveWeapon(B,"BotPack.enforcer");
	B.GotoState('Attacking');
}

function Timer() 
{
local Pawn P;
local int Enemies,Players;
	
	Super(TeamGamePlus).Timer();

	if (bGameEnded)
		return;
	
	Enemies = 0;
	Players = 0;

	for (P = Level.PawnList; P != None; P = P.NextPawn)
		{
		if (P.IsA('Bot'))
			{
			Enemies++;
			}
		if (P.IsA('PlayerPawn'))
			{
			Players++;
			}
		}
	if (Enemies < int(Level.IdealPlayerCount) + Players - 1)
		{
		AddNewEnemy();
		}
	HandleTemp();
}

function NavigationPoint FindPlayerStart( Pawn Player, optional byte InTeam, optional string incomingName )
{
	local PlayerStart Dest, Candidate[16], Best;
	local float Score[16], BestScore, NextDist;
	local pawn OtherPlayer;
	local int i, num;
	local Teleporter Tel;
	local NavigationPoint N;
	local byte Team;

	if ( Player.IsA('PlayerPawn') )
		{
		return TournamentPlayer(Player).StartSpot;
		}

	if (Player.IsA('Bot'))
		{
		Player.Destroy();
		}

	if ( (Player != None) && (Player.PlayerReplicationInfo != None) )
		//Team = Player.PlayerReplicationInfo.Team;
		Team = 0;
	else
		Team = 0;

	if( incomingName!="" )
		foreach AllActors( class 'Teleporter', Tel )
			if( string(Tel.Tag)~=incomingName )
				return Tel;

	if ( Team == 255 )
		Team = 0;
				
	//choose candidates	
	for ( N=Level.NavigationPointList; N!=None; N=N.nextNavigationPoint )
	{
		Dest = PlayerStart(N);
		if ( (Dest != None) && Dest.bEnabled
			&& (!bSpawnInTeamArea || (Team == Dest.TeamNumber)) )
		{
			if (num<16)
				Candidate[num] = Dest;
			else if (Rand(num) < 16)
				Candidate[Rand(16)] = Dest;
			num++;
		}
	}

	if (num == 0 )
	{
		log("Didn't find any player starts in list for team"@Team@"!!!"); 
		foreach AllActors( class'PlayerStart', Dest )
		{
			if (num<16)
				Candidate[num] = Dest;
			else if (Rand(num) < 16)
				Candidate[Rand(16)] = Dest;
			num++;
		}
		if ( num == 0 )
			return None;
	}

	if (num>16) 
		num = 16;
	
	//assess candidates
	for (i=0;i<num;i++)
	{
		if ( Candidate[i] == LastStartSpot )
			Score[i] = -6000.0;
		else
			Score[i] = 4000 * FRand(); //randomize
	}		
	
	for ( OtherPlayer=Level.PawnList; OtherPlayer!=None; OtherPlayer=OtherPlayer.NextPawn)	
		if ( OtherPlayer.bIsPlayer && (OtherPlayer.Health > 0) && !OtherPlayer.IsA('Spectator') )
			for (i=0; i<num; i++)
				if ( OtherPlayer.Region.Zone == Candidate[i].Region.Zone ) 
				{
					Score[i] -= 1500;
					NextDist = VSize(OtherPlayer.Location - Candidate[i].Location);
					if (NextDist < 2 * (CollisionRadius + CollisionHeight))
						Score[i] -= 1000000.0;
					else if ( (NextDist < 2000) && (OtherPlayer.PlayerReplicationInfo.Team != Team)
							&& FastTrace(Candidate[i].Location, OtherPlayer.Location) )
						Score[i] -= (10000.0 - NextDist);
				}
	
	BestScore = Score[0];
	Best = Candidate[0];
	for (i=1; i<num; i++)
		if (Score[i] > BestScore)
		{
			BestScore = Score[i];
			Best = Candidate[i];
		}
	LastStartSpot = Best;
				
	return Best;
}

function bool SetEndCams(string Reason)
{
/*
	local pawn P, Best;
	local PlayerPawn Player;

	// find individual winner
	for ( P=Level.PawnList; P!=None; P=P.nextPawn )
		if ( P.bIsPlayer && !P.IsA('Spectator') && ((Best == None) || (P.PlayerReplicationInfo.Score > Best.PlayerReplicationInfo.Score)) )
			Best = P;

	// check for tie
	for ( P=Level.PawnList; P!=None; P=P.nextPawn )
		if ( P.bIsPlayer && (Best != P) && (P.PlayerReplicationInfo.Score == Best.PlayerReplicationInfo.Score) )
		{
			BroadcastLocalizedMessage( DMMessageClass, 0 );
			return false;
		}		

	EndTime = Level.TimeSeconds + 3.0;
	GameReplicationInfo.GameEndedComments = Best.PlayerReplicationInfo.PlayerName@GameEndedMessage;
	log( "Game ended at "$EndTime);
	for ( P=Level.PawnList; P!=None; P=P.nextPawn )
	{
		Player = PlayerPawn(P);
		if ( Player != None )
		{
			if (!bTutorialGame)
				PlayWinMessage(Player, (Player == Best));
			Player.bBehindView = true;
			if ( Player == Best )
				Player.ViewTarget = None;
			else
				Player.ViewTarget = Best;
			Player.ClientGameEnded();
		}
		P.GotoState('GameEnded');
	}
	CalcEndStats();
*/
	UpdateDB();
	//return true;
}

defaultproperties
{
     bScoreTeamKills=True
     bBalanceTeams=False
     bPlayersBalanceTeams=False
     MaxTeams=2
     MaxAllowedTeams=2
     GoalTeamScore=0.000000
     MaxTeamSize=16
     StartUpTeamMessage=""
     TeamChangeMessage=""
     TeamColor(0)="Good"
     TeamColor(1)="Evil"
     TeamColor(2)="Green"
     TeamColor(3)="Gold"
     TEAM_Blue=1
     TEAM_Green=2
     TEAM_Gold=3
     CurrentOrders(0)=Defend
     CurrentOrders(1)=Defend
     CurrentOrders(2)=Defend
     CurrentOrders(3)=Defend
     StartupTeamTralier=""
     StartUpMessage="Destroy your oponents!"
     MaxCommanders=2
     bCanChangeSkin=False
     bTeamGame=True
     ScoreBoardType=Class'IA_SB'
     RulesMenuType="UTMenu.UTTeamRSClient"
     SettingsMenuType="UTMenu.UTTeamSSClient"
     HUDType=Class'IA_HUD'
     MapPrefix="IA"
     BeaconName="IA"
     GameName="Instant Action"
     MapListType=Class'IA_Maplist'
     //MutatorClass=Class'Mutator_Base'
     bCoopWeaponMode=True
     //GameReplicationInfoClass=Class'rpg_GRI'
}
